package com.penpower.idcamerademo;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;

public class MessageToast extends View {
    private TextPaint mTextPaint;
    private Path mPath = new Path();
    private String mMessage;

    public MessageToast(Context aContext, AttributeSet aAttrs) {
        super(aContext, aAttrs);
        initPaints();
    }

    public MessageToast(Context aContext) {
        super(aContext);
        initPaints();
    }

    private void initPaints() {
        mTextPaint = new TextPaint();
        mTextPaint.setColor(Color.WHITE);
        mTextPaint.setAntiAlias(true);
        mTextPaint.setTextSize(getResources().getDimension(R.dimen.camera_tip_text_size));
        mTextPaint.setTextAlign(Paint.Align.CENTER);
    }

    private void drawRectCanvas(Canvas aCanvas) {
        if (aCanvas != null) {
            mPath.reset();
            if (mMessage != null) {
                Rect textRect = new Rect();
                mTextPaint.getTextBounds(mMessage, 0, mMessage.length(), textRect);

                float left = getWidth() / 2 - textRect.width() / 2 - getResources().getDimension(R.dimen.message_bg_margin_lr);
                float top = getHeight() / 2 - textRect.height() / 2 - getResources().getDimension(R.dimen.message_bg_margin_tb);
                float right = getWidth() / 2 + textRect.width() / 2 + getResources().getDimension(R.dimen.message_bg_margin_lr);
                float bottom = getHeight() / 2 + textRect.height() / 2 + getResources().getDimension(R.dimen.message_bg_margin_tb);
                if (mMessage.length() == 0) {
                    left = 0;
                    top = 0;
                    right = 0;
                    bottom = 0;
                }

                RectF rect = new RectF(left, top, right, bottom);
                Paint rectPaint = new Paint();
                rectPaint.setColor(getResources().getColor(R.color.ap_message_tip_bg));
                rectPaint.setStyle(Paint.Style.FILL);
                aCanvas.drawRoundRect(rect, getResources().getDimension(R.dimen.message_bg_radius), getResources().getDimension(R.dimen.message_bg_radius), rectPaint);

                if (mMessage.length() > 0) {
                    Paint.FontMetrics fontMetrics = mTextPaint.getFontMetrics();
                    int baseLineY = (int) (rect.centerY() - fontMetrics.top / 2 - fontMetrics.bottom / 2);
                    aCanvas.drawText(mMessage, rect.centerX(), baseLineY, mTextPaint);
                }
            }
        }
    }

    @Override
    protected void onDraw(Canvas aCanvas) {
        super.onDraw(aCanvas);
        drawRectCanvas(aCanvas);
    }

    public void setMessage(String aMessage) {
        if (aMessage != null && aMessage.length() > 0) {
            mMessage = aMessage;
            setVisibility(View.VISIBLE);
        } else {
            setVisibility(View.GONE);
        }
        invalidate();
    }
}
